/*____________________________________________________________________________
	Copyright (C) 1997 Network Associates Inc. and affiliated companies.
	All rights reserved.
	
	
	
	$Id: CCRSEntrustServer.h,v 1.4 2000/07/10 22:04:59 dallen Exp $
____________________________________________________________________________*/

#ifndef Included_CCRSEntrustServer_h
#define Included_CCRSEntrustServer_h

#include "CCRSServer.h"

class CCRSEntrustServer : public CCRSServer {
public:
					CCRSEntrustServer(PGPContextRef inContext,
						const char * inHostName, PGPUInt32 inHostAddress,
						PGPUInt16 inHostPort, const char * inPath,
						PGPKeyServerProtocol inProtocol,
						PGPKeyServerClass inClass);
	virtual			~CCRSEntrustServer();
	
	virtual void	SendCertificateRequest(PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inRequestKey, 
							const void * inBuffer, PGPSize inBufferSize, void ** outBuffer,
							PGPSize * outBufferSize);
	virtual void	RetrieveCertificate(PGPFilterRef inSearchFilter, PGPKeyDBObjRef inSearchKey,
	    					PGPKeyDBObjRef inCAKey,
						PGPKeyDBObjRef inSigningKey, PGPByte * inPassphrase,
						PGPSize inPassphraseLength, PGPBoolean inIsPassphrase,
						void ** outBuffer, PGPSize * outBufferSize);
	virtual void	RetrieveCRL(PGPKeyDBObjRef inCAKey, PGPKeyDBObjRef inSigningKey,
						PGPByte * inPassphrase, PGPSize inPassphraseLength,
						PGPBoolean inIsPassphrase, void ** outBuffer, PGPSize * outBufferSize);

protected:
	PGPUInt32		PostMessage(PGPKeyServerState inOperation, const PGPByte * inMessage,
						PGPSize inMessageLength, PGPByte ** outResult);

	void			PackageAndSendMessage(PGPExportFormat inExportFormat,
						PGPOutputFormat inOutputFormat, PGPKeyDBObjRef inKey, PGPKeyDBObjRef inSigningKey,
						PGPByte * inPassphrase, PGPSize inPassphraseLength,
						PGPBoolean inIsPassphrase, PGPByte * inDistributionPoint,
						PGPSize inDistributionPointSize, void ** outBuffer,
						PGPSize * outBufferSize);
};



#endif
